/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import cz.insophy.inplan.remote.common.WorkplaceCalendarInformation;
import cz.insophy.inplan.remote.common.WorkplaceCalendarRequest;
import cz.insophy.inplan.remote.common.WorkplaceCalendarTemplate;
import cz.insophy.inplan.util.CalendarHelper;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.TimeSpan;
import cz.insophy.inplan.util.TimeSpiller;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WpCalUtils {
    private static final Logger log = LoggerFactory.getLogger(WpCalUtils.class);
    private static final String ERP = Localizer.getString("load_calendar.erp");
    private static final String DEFAULT = Localizer.getString("load_calendar.default");
    public static final WorkplaceCalendarInformation.TemplateDescription ERP_TEMPLATE = new WorkplaceCalendarInformation.TemplateDescription(ERP, "", WorkplaceCalendarRequest.RequestType.ERP);
    public static final WorkplaceCalendarInformation.TemplateDescription WP_DEFAULT_TEMPLATE = new WorkplaceCalendarInformation.TemplateDescription(DEFAULT, "", WorkplaceCalendarRequest.RequestType.WORKPLACE_DEFAULT);
    public static final long MILLIS_PER_WEEK = 604800000L;
    private static final long D = 86400000L;
    private static final long H = 3600000L;
    private static final TimeSpiller WORKDAYS_SPILLER = TimeSpiller.serial(TimeSpiller.parallel(TimeSpiller.interval(21600000L, 79200000L), TimeSpiller.interval(108000000L, 165600000L), TimeSpiller.interval(194400000L, 252000000L), TimeSpiller.interval(280800000L, 338400000L), TimeSpiller.interval(367200000L, 424800000L)), TimeSpiller.parallel(TimeSpiller.serial(TimeSpiller.reversedInterval(0L, 21600000L), TimeSpiller.reversedInterval(597600000L, 604800000L)), TimeSpiller.reversedInterval(79200000L, 108000000L), TimeSpiller.reversedInterval(165600000L, 194400000L), TimeSpiller.reversedInterval(252000000L, 280800000L), TimeSpiller.reversedInterval(338400000L, 367200000L)));
    private static final TimeSpiller SATURDAY_SPILLER = TimeSpiller.serial(TimeSpiller.interval(453600000L, 511200000L), TimeSpiller.reversedInterval(424800000L, 453600000L));
    private static final TimeSpiller SUNDAY_SPILLER = TimeSpiller.serial(TimeSpiller.interval(540000000L, 597600000L), TimeSpiller.reversedInterval(511200000L, 540000000L));
    private static final TimeSpiller WEEK_SPILLER = TimeSpiller.serial(WORKDAYS_SPILLER, SATURDAY_SPILLER, SUNDAY_SPILLER);

    private static long adjustForDst(boolean isFromInDst, long time, TimeZone tz) {
        boolean isTimeInDst = tz.inDaylightTime(new Date(time));
        if (isFromInDst && !isTimeInDst) {
            return time + (long)tz.getDSTSavings();
        }
        if (!isFromInDst && isTimeInDst) {
            return time - (long)tz.getDSTSavings();
        }
        return time;
    }

    public static List<TimeSpan> onlinesToOfflines(List<TimeSpan> onlines, long from, long to) {
        if (onlines.size() < 1) {
            return Lists.newArrayList(TimeSpan.fromStartEnd(from, to));
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(from);
        c.set(7, 2);
        CalendarHelper.setDayStart(c);
        if (c.getTimeInMillis() > from) {
            c.add(3, -1);
        }
        long shift = c.getTimeInMillis();
        TimeZone tz = TimeZone.getDefault();
        boolean isFromInDst = tz.inDaylightTime(new Date(from));
        ArrayList<TimeSpan> res = new ArrayList<TimeSpan>();
        long offlineStart = from;
        Iterator<TimeSpan> oIt = onlines.iterator();
        while (offlineStart < to) {
            if (!oIt.hasNext()) {
                oIt = onlines.iterator();
                shift += 604800000L;
            }
            TimeSpan online = oIt.next();
            long offlineEnd = online.getStart() + shift;
            offlineStart = Math.max(WpCalUtils.adjustForDst(isFromInDst, offlineStart, tz), from);
            if ((offlineEnd = Math.min(WpCalUtils.adjustForDst(isFromInDst, offlineEnd, tz), to)) > offlineStart) {
                res.add(TimeSpan.fromStartEnd(offlineStart, offlineEnd));
            }
            offlineStart = Math.max(online.getEnd() + shift, from);
        }
        return res;
    }

    public static List<TimeSpan> createDefaultCalendarTemplate(long weekOnlineTime, String workplaceName) {
        long time = WpCalUtils.clampTime(weekOnlineTime, 604800000L, "week", workplaceName);
        return WEEK_SPILLER.spill(time);
    }

    public static WorkplaceCalendarTemplate getDefaultWorkplaceCalendarTemplate(String workplaceName, long start, long end, long weekOnlineTime) {
        List<TimeSpan> onlines = WpCalUtils.createDefaultCalendarTemplate(weekOnlineTime, workplaceName);
        List<TimeSpan> offlines = WpCalUtils.onlinesToOfflines(onlines, start, end);
        return new WorkplaceCalendarTemplate(workplaceName, start, end, offlines);
    }

    public static List<TimeSpan> cleanupSpans(List<TimeSpan> spans) {
        ArrayList<TimeSpan> res;
        if (spans.size() > 0) {
            res = Lists.newArrayList();
            TimeSpan lastSpan = spans.get(0);
            ListIterator<TimeSpan> iterator = spans.listIterator(1);
            while (iterator.hasNext()) {
                TimeSpan span = iterator.next();
                if (span.isEmpty()) continue;
                if (span.getStart() > lastSpan.getEnd()) {
                    res.add(lastSpan);
                    lastSpan = span;
                    continue;
                }
                lastSpan = TimeSpan.union(lastSpan, span);
            }
            res.add(lastSpan);
        } else {
            res = Collections.emptyList();
        }
        return res;
    }

    public static List<TimeSpan> createWeekCalendarTemplate(long workdayOnlineTime, long saturdayOnlineTime, long sundayOnlineTime, String workplaceName) {
        workplaceName = Strings.nullToEmpty(workplaceName);
        workdayOnlineTime = WpCalUtils.clampTime(workdayOnlineTime, 86400000L, "workday", workplaceName);
        saturdayOnlineTime = WpCalUtils.clampTime(saturdayOnlineTime, 86400000L, "saturday", workplaceName);
        sundayOnlineTime = WpCalUtils.clampTime(sundayOnlineTime, 86400000L, "sunday", workplaceName);
        ArrayList<TimeSpan> res = Lists.newArrayList();
        res.addAll(WORKDAYS_SPILLER.spill(5L * workdayOnlineTime));
        res.addAll(SATURDAY_SPILLER.spill(saturdayOnlineTime));
        res.addAll(SUNDAY_SPILLER.spill(sundayOnlineTime));
        return TimeSpan.intervalUnion(res);
    }

    private static long clampTime(long intervalOnlineTime, long upperLimit, String intervalName, String wpName) {
        long onlineTime = intervalOnlineTime;
        if (onlineTime > upperLimit) {
            log.warn("Reducing {} online time to {} hours at {}.", intervalName, upperLimit / 3600000L, wpName);
            onlineTime = upperLimit;
        }
        if (onlineTime < 0L) {
            log.warn("Negative {} online time given at {}. Treating as 0.", (Object)intervalName, (Object)wpName);
            onlineTime = 0L;
        }
        return onlineTime;
    }
}

